import random
import time
from parse_config import Config
from CreateCluster import CreateCluster
from utils import create_data_array, plot_save_clusters, generate_output_df, create_non_drop_data_arr, get_train_vins, plot_and_save_load_profiles

if __name__ == "__main__":
    start = time.time()
    
    params = Config.from_file('config.json')
    random.seed(params.random_state)
    
    train_raw_ns, valid_train_vins, drop_train_vins, valid_train_weeks, drop_train_weeks, scaler = create_data_array(params.features_dir)
    cluster = CreateCluster(params)
    labels, cluster_res = cluster.cluster_data(train_raw_ns)
    print("Time taken for clustering  --- %s mins ---" % ((time.time() - start)/60.0))
    
    toc = time.time()
    train_vins = get_train_vins(params.features_dir)
    train_characterize = create_non_drop_data_arr(params.features_dir)

    _dir = plot_save_clusters(labels, params)
    output = generate_output_df(train_vins, params.features_dir, valid_train_vins, 
                                valid_train_weeks, drop_train_vins, 
                                drop_train_weeks, labels 
                                )
    
    output_filename = f"{_dir}/output.csv"
    output.to_csv(output_filename)
    
    success = plot_and_save_load_profiles(train_characterize, train_raw_ns, output, params.cluster_algo, _dir, scaler, cluster_res)
    
    print("Time taken for d creating UMAP, MDS and characterization plots --- %s mins ---" % ((time.time() - toc)/60.0))

